<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'middle_name', 'last_name', 'email', 'mobile', 'password', 'status');

    public function departments()
    {
        return $this->belongsToMany('App\Models\Department')->withPivot();
    }

    public function executions()
    {
        return $this->hasMany('App\Models\ProcessExecution');
    }

    public function executionSteps()
    {
        return $this->hasMany('App\Models\ProcessExecutionStep');
    }

}